/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.net;

import com.ibm.hwmca.fw.net.LocalSocketImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;

public class LocalSocket {
    LocalSocketImpl impl;

    public LocalSocket(String path) throws IOException {
        this.impl = new LocalSocketImpl();
        this.impl.connect(path);
    }

    public LocalSocket(String path, String localPath) throws IOException {
        this.impl = new LocalSocketImpl();
        this.impl.bind(localPath);
        this.impl.connect(path);
    }

    LocalSocket(LocalSocketImpl impl) {
        this.impl = impl;
    }

    public String getPeerAddress() throws IOException {
        return this.impl.getPeerAddress();
    }

    public String getLocalAddress() throws IOException {
        return this.impl.getLocalAddress();
    }

    public InputStream getInputStream() throws IOException {
        return this.impl.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.impl.getOutputStream();
    }

    public void setSoLinger(boolean on) throws SocketException {
        this.impl.setSoLinger(on);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.impl.setSoLinger(on, linger);
    }

    public int getSoLinger() throws SocketException {
        return this.impl.getSoLinger();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.impl.setSoTimeout(timeout);
    }

    public int getSoTimeout() throws SocketException {
        return this.impl.getSoTimeout();
    }

    public void close() throws IOException {
        this.impl.close();
    }

    public void shutdownInput() throws IOException {
        this.impl.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.impl.shutdownOutput();
    }

    public static void removeSocket(String path) {
        File socketFile = new File(path);
        if (!socketFile.exists()) {
            return;
        }
        socketFile.delete();
    }

    public static LocalSocket[] getSocketPair() throws IOException {
        LocalSocketImpl[] socketImpls = LocalSocketImpl.getSocketPair();
        LocalSocket[] sockets = new LocalSocket[]{new LocalSocket(socketImpls[0]), new LocalSocket(socketImpls[1])};
        return sockets;
    }

    public int getFd() {
        return this.impl.getFd();
    }
}

